/* ---------------------------------------------------------------------------
    2016 HID Global Corporation/ASSA ABLOY AB.  All rights reserved.

   Redistribution and use in source and binary forms, with or without modification,
   are permitted provided that the following conditions are met:
      - Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      - Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
        AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
        THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
        FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
        (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
        LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
        ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
        (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
        THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 --------------------------------------------------------------------------- */
 
#include "stdafx.h"

#include "Scenarios.h"
#include "Scenarios.UI.h"
#include "Helper.h"

extern PKCS_SPL_TS_TextCode PKCS_return_code[];
//------------------------------
//	 Function: DisplayMenuHeader
//
//	Display Menu Header function
//		return	void
//		param	void
//------------------------------
void DisplayMenuHeader()
{
    /* Local variables */
    CK_RV rc = 0;
    CK_INFO info;
    CK_VERSION version;
    int major = 0;
    int minor = 0;

    /* Get PKCS version */
    rc = C_Initialize(NULL_PTR);
    if (rc == CKR_OK)
    {
        rc = C_GetInfo(&info);

        /* Display general information about Cryptoki */
        //DisplayGeneralInfo (&info);

        version = info.cryptokiVersion;
        major = (int)version.major;
        minor = (int)version.minor;

        rc = C_Finalize(NULL);
    }

    system("CLS");

    /* Display test program information */
    fwprintf(stdout, _T("\n%s\n"), LEGALCOPYRIGHT);
    fwprintf(stdout, _T("\n%s\n"), PRODUCTNAME);
    fwprintf(stdout, _T("\n%s%d.%d%s\n"), DESCRIPTION1, major, minor, DESCRIPTION2);
}

//------------------------------------------------------------------
//	 Function: DisplayInfo
//
//	Display string content
//		return	void
//		param	[IN] char*  szStr			: String to be displayed
//		param	[IN] unsigned long ulStrLen	: String length
//------------------------------------------------------------------
void DisplayInfo(char*  szStr, unsigned long ulStrLen)
{
    /* Local variables */
    char* 			Ptr = szStr;
    unsigned long	ulTestLen = __min(ulStrLen, (ULONG)strlen(szStr));
    short			bFlagStop = FALSE;
    unsigned long	i = 0;

    do
    {
        if ((*(Ptr + i) == ' ') && (*(Ptr + i + 1) == ' '))
        {
            bFlagStop = TRUE;
        }
        else
        {
            fprintf(stdout, "%c", *(Ptr + i));
        }
    } while ((++i<ulTestLen) && (bFlagStop == FALSE));

    return;
}

//-------------------------------------------------------------------------------
//	 Function: DisplaySlotInfo
//
//	Display slot informations
//		return	void
//		param	[IN] int nSlotID		: The slot number
//		param	[IN] CK_INFO *pSlotInfo	: Structure containing slot informations
//--------------------------------------------------------------------------------
void DisplaySlotInfo(int nSlotID, CK_SLOT_INFO *pSlotInfo)
{
    fwprintf(stdout, _T("\n\n    --- SLOT INFORMATION ---"));
    fwprintf(stdout, _T("\n\nSlot ID................... : %d"), nSlotID);
    fwprintf(stdout, _T("\n"));
    fwprintf(stdout, _T("\nSlot description ......... : "));

    DisplayInfo((char*)pSlotInfo->slotDescription, 64);

    fwprintf(stdout, _T("\nManufacturer ID .......... : "));

    DisplayInfo((char*)pSlotInfo->manufacturerID, 32);

    fwprintf(stdout,
        _T("\nHardware version ......... : %d.%d"),
        pSlotInfo->hardwareVersion.major,
        pSlotInfo->hardwareVersion.minor);

    fwprintf(stdout,
        _T("\nFirmware version ......... : %d.%d"),
        pSlotInfo->firmwareVersion.major,
        pSlotInfo->firmwareVersion.minor);

    fwprintf(stdout, _T("\n"));
}

//--------------------------------------------------------------------------------------
//	 Function: DisplayTokenInfo
//
//	Display token informations
//		return	void
//		param	[IN] CK_TOKEN_INFO *pTokenInfo : Structure containing token informations
//---------------------------------------------------------------------------------------
void DisplayTokenInfo(CK_TOKEN_INFO *pTokenInfo)
{

    fwprintf(stdout, _T("\n\n    --- TOKEN INFORMATION ---"));
    fwprintf(stdout, _T("\n\nLabel .................... : "));

    DisplayInfo((char*)pTokenInfo->label, 32);

    fwprintf(stdout, _T("\nManufacturer ID .......... : "));

    DisplayInfo((char*)pTokenInfo->manufacturerID, 32);

    fwprintf(stdout, _T("\nModel .................... : "));

    DisplayInfo((char*)pTokenInfo->model, 16);

    fwprintf(stdout, _T("\nFlags .................... : 0x%lX ("), pTokenInfo->flags);

    if (pTokenInfo->flags & CKF_RNG) fwprintf(stdout, _T("CKF_RNG|"));
    if (pTokenInfo->flags & CKF_WRITE_PROTECTED) fwprintf(stdout, _T("CKF_WRITE_PROTECTED|"));
    if (pTokenInfo->flags & CKF_LOGIN_REQUIRED) fwprintf(stdout, _T("CKF_LOGIN_REQUIRED|"));
    if (pTokenInfo->flags & CKF_USER_PIN_INITIALIZED) fwprintf(stdout, _T("CKF_USER_PIN_INITIALIZED|"));
    if (pTokenInfo->flags & CKF_RESTORE_KEY_NOT_NEEDED) fwprintf(stdout, _T("CKF_RESTORE_KEY_NOT_NEEDED|"));
    if (pTokenInfo->flags & CKF_CLOCK_ON_TOKEN) fwprintf(stdout, _T("CKF_CLOCK_ON_TOKEN|"));
    if (pTokenInfo->flags & CKF_PROTECTED_AUTHENTICATION_PATH) fwprintf(stdout, _T("CKF_PROTECTED_AUTHENTICATION_PATH|"));
    if (pTokenInfo->flags & CKF_DUAL_CRYPTO_OPERATIONS) fwprintf(stdout, _T("CKF_DUAL_CRYPTO_OPERATIONS|"));
    if (pTokenInfo->flags & CKF_TOKEN_INITIALIZED) fwprintf(stdout, _T("CKF_TOKEN_INITIALIZED|"));
    if (pTokenInfo->flags & CKF_SECONDARY_AUTHENTICATION) fwprintf(stdout, _T("CKF_SECONDARY_AUTHENTICATION|"));
    if (pTokenInfo->flags & CKF_USER_PIN_COUNT_LOW) fwprintf(stdout, _T("CKF_USER_PIN_COUNT_LOW|"));
    if (pTokenInfo->flags & CKF_USER_PIN_FINAL_TRY) fwprintf(stdout, _T("CKF_USER_PIN_FINAL_TRY|"));
    if (pTokenInfo->flags & CKF_USER_PIN_LOCKED) fwprintf(stdout, _T("CKF_USER_PIN_LOCKED|"));
    if (pTokenInfo->flags & CKF_USER_PIN_TO_BE_CHANGED) fwprintf(stdout, _T("CKF_USER_PIN_TO_BE_CHANGED|"));
    if (pTokenInfo->flags & CKF_SO_PIN_COUNT_LOW) fwprintf(stdout, _T("CKF_SO_PIN_COUNT_LOW|"));
    if (pTokenInfo->flags & CKF_SO_PIN_FINAL_TRY) fwprintf(stdout, _T("CKF_SO_PIN_FINAL_TRY|"));
    if (pTokenInfo->flags & CKF_SO_PIN_LOCKED) fwprintf(stdout, _T("CKF_SO_PIN_LOCKED|"));
    if (pTokenInfo->flags & CKF_SO_PIN_TO_BE_CHANGED) fwprintf(stdout, _T("CKF_SO_PIN_TO_BE_CHANGED"));

    fwprintf(stdout, _T(")"));
    fwprintf(stdout, _T("\nSerial number ............ : "));

    DisplayInfo((char*)pTokenInfo->serialNumber, 16);

    fwprintf(stdout, _T("\nMax session count ........ : %ld"), pTokenInfo->ulMaxSessionCount);
    fwprintf(stdout, _T("\nCurrent session count .... : %ld"), pTokenInfo->ulSessionCount);
    fwprintf(stdout, _T("\nMax RW session count ..... : %ld"), pTokenInfo->ulMaxRwSessionCount);
    fwprintf(stdout, _T("\nCurrent RW session count . : %ld"), pTokenInfo->ulRwSessionCount);
    fwprintf(stdout, _T("\nMax PIN length ........... : %ld"), pTokenInfo->ulMaxPinLen);
    fwprintf(stdout, _T("\nMin PIN length ........... : %ld"), pTokenInfo->ulMinPinLen);
    fwprintf(stdout, _T("\nTotal public memory ...... : %ld"), pTokenInfo->ulTotalPublicMemory);
    fwprintf(stdout, _T("\nTotal free public memory . : %ld"), pTokenInfo->ulFreePublicMemory);
    fwprintf(stdout, _T("\nTotal private memory ..... : %ld"), pTokenInfo->ulTotalPrivateMemory);
    if (pTokenInfo->ulFreePrivateMemory == (unsigned long)(-1))
    {
        fwprintf(stdout, _T("\nTotal free private memory  : unavailable"));
    }
    else
    {
        fwprintf(stdout, _T("\nTotal free private memory  : %ld"), pTokenInfo->ulFreePrivateMemory);
    }
    fwprintf(stdout,
        _T("\nhardwareVersion .......... : %d.%d"),
        pTokenInfo->hardwareVersion.major,
        pTokenInfo->hardwareVersion.minor);
    fwprintf(stdout,
        _T("\nfirmwareVersion .......... : %d.%d"),
        pTokenInfo->firmwareVersion.major,
        pTokenInfo->firmwareVersion.minor);
    fwprintf(stdout, _T("\nUTC time ................. : "));

    DisplayInfo((char*)pTokenInfo->utcTime, 16);

    fwprintf(stdout, _T("\n"));
}

//-------------------------------------------------------------------------------------
//	 Function: DisplayGeneralInfo
//
//	Display general informations about PKCS library
//		return	void
//		param	[IN] CK_INFO *pInfoStr : Structure containing PKCS library informations
//--------------------------------------------------------------------------------------
void DisplayGeneralInfo(CK_INFO *pInfoStr)
{
    fwprintf(stdout, _T("\n\n    --- GENERAL INFORMATION ---"));

    fwprintf(stdout, _T("\n\nManufacturer ID .......... : "));

    DisplayInfo((char*)pInfoStr->manufacturerID, 32);

    fwprintf(stdout,
        _T("\nCryptoki version ......... : %d.%d"),
        pInfoStr->cryptokiVersion.major,
        pInfoStr->cryptokiVersion.minor);

    fwprintf(stdout, _T("\nLibrary description ...... : "));

    DisplayInfo((char*)pInfoStr->libraryDescription, 32);

    fwprintf(stdout,
        _T("\nLibrary version .......... : %d.%d"),
        pInfoStr->libraryVersion.major,
        pInfoStr->libraryVersion.minor);

    fwprintf(stdout, _T("\n"));
}

//---------------------------------------------------------------------------------------------
//	 Function: DisplayErrorCode
//
//	Interpret and print return PKCS code on screen
//		return	void
//		param	[IN] CK_CHAR_PTR	RetString : Return code after execution of an PKCS function
//		param	[IN] CK_RV RetCode	String	  : Associated string information
//---------------------------------------------------------------------------------------------
void DisplayErrorCode(CK_CHAR_PTR  RetString, CK_RV RetCode)
{
    /* Local variables */
    CK_ULONG iLevel;
    CK_BBOOL Result;


    iLevel = Code2Text(RetCode, PKCS_SPL_RET_CODE, &Result);
    if (Result == TRUE)
    {
        fprintf(stdout, "%s => %s", RetString, &PKCS_return_code[iLevel].Text[0]);
    }
    else
    {
        fprintf(stdout, "%s => 0x%x", RetString, RetCode);
    }
}

//------------------------------------------------------------------
//	 Function: DisplayByte
//
//	Display string content in hexadecimal format
//		return	void
//		param	[IN] LPTSTR	szStr			: String to be displayed
//		param	[IN] unsigned long ulStrLen	: String length
//------------------------------------------------------------------
void DisplayByte(unsigned char* szStr, unsigned long ulStrLen)
{
    /* Local variables */
    unsigned long	i = 0;

    /* control length of data to be displayed */
    if ((ulStrLen == (unsigned long)(-1))
        || (ulStrLen == 0))
    {
        fprintf(stdout, "No data available");
    }
    else
    {
        for (i = 0; i<ulStrLen; i++)
        {
            fprintf(stdout, " %02X", (unsigned char)szStr[i]);
        }
    }
}



